/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    id: root

    property var formats
    property string currentFormat

    signal formatClicked(string format)

    SilicaListView {
        anchors.fill: parent

        header: PageHeader {
            //% "Paper size"
            title: qsTrId("components_pickers-la-paper-size")
        }
        model: formats
        currentIndex: Array.prototype.indexOf.call(formats, currentFormat)
        delegate: BackgroundItem {
            id: delegateItem

            onClicked:  {
                root.formatClicked(modelData)
                pageStack.pop()
            }

            width: ListView.view.width

            Label {
                x: Theme.horizontalPageMargin
                anchors.verticalCenter: parent.verticalCenter
                width: parent.width - x * 2
                wrapMode: Text.Wrap
                text: modelData
                color: (delegateItem.highlighted || delegateItem.ListView.isCurrentItem)
                       ? Theme.highlightColor
                       : Theme.primaryColor
            }
        }
        VerticalScrollDecorator {}
    }
}
