/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.FileManager 1.0

PullDownMenu {
    id: pdm

    property var closeAction
    property var sourceModel
    property var currentPage
    property var currentView

    onActiveChanged: {
        if (!active && closeAction) {
            closeAction()
            closeAction = undefined
        }
    }

    MenuItem {
        onClicked: pdm.closeAction = function() { sourceModel.includeHiddenFiles = !sourceModel.includeHiddenFiles }
                                             //% "Hide hidden files"
        text: sourceModel.includeHiddenFiles ? qsTrId("components_pickers-me-hide_hidden_files")
                                             //% "Show hidden files"
                                           : qsTrId("components_pickers-me-show_hidden_files")
    }

    MenuItem {
        function pop() {
            pageStack.pop()

            sourceModel.sortByChanged.disconnect(pop)
            sourceModel.sortOrderChanged.disconnect(pop)
        }

        onClicked: {
            var obj = pageStack.animatorPush(sortingPage)
            obj.pageCompleted.connect(function(dialog) {
                dialog.selected.connect(
                            function(sortBy, sortOrder, directorySort) {
                                if (sortBy !== sourceModel.sortBy || sortOrder !== sourceModel.sortOrder) {
                                    sourceModel.sortBy = sortBy
                                    sourceModel.sortOrder = sortOrder
                                    sourceModel.directorySort = directorySort

                                    // Wait for the changes to take effect
                                    // before popping the sorting page
                                    sourceModel.sortByChanged.connect(pop)
                                    sourceModel.sortOrderChanged.connect(pop)
                                } else {
                                    pageStack.pop()
                                }
                            })
            })
        }

        //% "Sort"
        text: qsTrId("components_pickers-me-sort")
        visible: sourceModel.count > 0

        Component {
            id: sortingPage

            SortingPage {
                allowedOrientations: currentPage.allowedOrientations
            }
        }
    }

    MenuItem {
        onClicked: {
            sourceModel.selectFilesWithoutDirectories()
            currentPage.updateSelectedFiles(true)
        }

        text: qsTrId("pickers-me-select_all")
        visible: sourceModel.selectedCount >= 0 && currentView.fileCount > sourceModel.selectedCount && currentView.selectionEnabled
    }

    MenuItem {
        onClicked: {
            sourceModel.clearSelectedFiles()
            currentPage.updateSelectedFiles(false)
        }

        text: qsTrId("pickers-me-clear_selection")
        visible: sourceModel.selectedCount > 0 && currentView.selectionEnabled
    }
}
