/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Pickers 1.0
import Sailfish.Gallery 1.0
import Sailfish.Media 1.0
import "mediaformatter.js" as MediaFormatter
import "private"

PickerDialog {
    id: musicPickerDialog

    property bool preview

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: musicPickerDialog
    }

    MusicModel {
        id: musicModel

        selectedModel: _selectedModel
        singleSelectionMode: preview
    }

    PickerGridView {
        id: gridView

        dialog: musicPickerDialog
        //: Placeholder text of music search field in content picker
        //% "Search music"
        headerPlaceholderText: qsTrId("components_pickers-ph-search_music")
        emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")
        contentType: ContentType.Music
        itemModel: musicModel
        selectedCount: _selectedCount
        clearOnBackstep: _clearOnBackstep
        glassOnly: musicPickerDialog._background
        animationDuration: _animationDuration
        model: musicModel.model
    }
}
