/****************************************************************************************
 *
 * Copyright (C) 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 *
 *****************************************************************************************/

#ifndef SAILFISH_ACCESSSWITCHPLUGIN_H
#define SAILFISH_ACCESSSWITCHPLUGIN_H

#include <QObject>

namespace Sailfish {

class Q_DECL_EXPORT AccessSwitchPlugin : public QObject
{
    Q_OBJECT
public:
    virtual QVariant keyValue(const QString &key) = 0;
    virtual int setKeyValue(const QString &key, const QVariant &value) = 0;
    virtual QHash<QString,QList<int>> switches() = 0;
signals:
    void keyValueChanged(const QString &key, const QVariant &value);
};

}

Q_DECLARE_INTERFACE(Sailfish::AccessSwitchPlugin, "org.sailfishos.AccessSwitchPlugin/1.0")

#endif // SAILFISH_ACCESSSWITCHPLUGIN_H
