/**
 *
 * Copyright (C) 2013 - 2014 Jolla Ltd.
 * Copyright (C) 2022 Open Mobile Platfrom LLC.
 * All rights reserved.
 *
 * This file is part of libauroraapp
 *
 * You may use this file under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software Foundation
 * and appearing in the file license.lgpl included in the packaging
 * of this file.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation
 * and appearing in the file license.lgpl included in the packaging
 * of this file.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 **/

#ifndef LIBAURORAAPP_AURORAAPP_H
#define LIBAURORAAPP_AURORAAPP_H

#ifdef QT_QML_DEBUG
#include <QtQuick>
#endif

#include <QtGlobal>
#include <QDir>
#include <QUrl>

class QGuiApplication;
class QQuickView;
class QString;

#if defined(LIBAURORAAPP_LIBRARY)
#  define AURORAAPP_EXPORT Q_DECL_EXPORT
#else
#  define AURORAAPP_EXPORT Q_DECL_IMPORT
#endif

namespace Aurora {
namespace Application {

// Simple interface: Get boosted application and view
AURORAAPP_EXPORT QGuiApplication *application(int &argc, char **argv);
AURORAAPP_EXPORT QQuickView *createView();

// Get fully-qualified path to a file in the data directory
AURORAAPP_EXPORT QUrl pathTo(const QString &filename);

// Get fully-qualified path to the "qml/<appname>.qml"  file
AURORAAPP_EXPORT QUrl pathToMainQml();

// Get fully-qualified path to a file in the organization's data directory
AURORAAPP_EXPORT QUrl organizationPathTo(const QString &filename);

AURORAAPP_EXPORT QDir filesDir(bool shared = false);

AURORAAPP_EXPORT QDir cacheDir(bool shared = false);

AURORAAPP_EXPORT QDir organizationFilesDir(bool shared = false);

AURORAAPP_EXPORT QDir organizationCacheDir(bool shared = false);

// Very simple interface: Uses "qml/<appname>.qml" as QML entry point
AURORAAPP_EXPORT int main(int &argc, char **argv);

} // namespace Application
} // namespace Aurora

/* Forward-declare that main() is exportable (needed for booster) */
Q_DECL_EXPORT int main(int argc, char *argv[]);

#endif /* LIBAURORAAPP_AURORAAPP_H */
