/* Generated by wayland-scanner 1.19.0 */

#ifndef INPUT_METHOD_SERVER_PROTOCOL_H
#define INPUT_METHOD_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_input_method The input_method protocol
 * @section page_ifaces_input_method Interfaces
 * - @subpage page_iface_wl_input_method_context - input method context
 * - @subpage page_iface_wl_input_method - input method
 * - @subpage page_iface_wl_input_panel - interface for implementing keyboards
 * - @subpage page_iface_wl_input_panel_surface - 
 * @section page_copyright_input_method Copyright
 * <pre>
 *
 * Copyright © 2012, 2013 Intel Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_input_method;
struct wl_input_method_context;
struct wl_input_panel;
struct wl_input_panel_surface;
struct wl_keyboard;
struct wl_output;
struct wl_surface;

#ifndef WL_INPUT_METHOD_CONTEXT_INTERFACE
#define WL_INPUT_METHOD_CONTEXT_INTERFACE
/**
 * @page page_iface_wl_input_method_context wl_input_method_context
 * @section page_iface_wl_input_method_context_desc Description
 *
 * Corresponds to a text model on input method side. An input method context
 * is created on text mode activation on the input method side. It allows to
 * receive information about the text model from the application via events.
 * Input method contexts do not keep state after deactivation and should be
 * destroyed after deactivation is handled.
 *
 * Text is generally UTF-8 encoded, indices and lengths are in bytes.
 *
 * Serials are used to synchronize the state between the text input and
 * an input method. New serials are sent by the text input in the
 * commit_state request and are used by the input method to indicate
 * the known text input state in events like preedit_string, commit_string,
 * and keysym. The text input can then ignore events from the input method
 * which are based on an outdated state (for example after a reset).
 * @section page_iface_wl_input_method_context_api API
 * See @ref iface_wl_input_method_context.
 */
/**
 * @defgroup iface_wl_input_method_context The wl_input_method_context interface
 *
 * Corresponds to a text model on input method side. An input method context
 * is created on text mode activation on the input method side. It allows to
 * receive information about the text model from the application via events.
 * Input method contexts do not keep state after deactivation and should be
 * destroyed after deactivation is handled.
 *
 * Text is generally UTF-8 encoded, indices and lengths are in bytes.
 *
 * Serials are used to synchronize the state between the text input and
 * an input method. New serials are sent by the text input in the
 * commit_state request and are used by the input method to indicate
 * the known text input state in events like preedit_string, commit_string,
 * and keysym. The text input can then ignore events from the input method
 * which are based on an outdated state (for example after a reset).
 */
extern const struct wl_interface wl_input_method_context_interface;
#endif
#ifndef WL_INPUT_METHOD_INTERFACE
#define WL_INPUT_METHOD_INTERFACE
/**
 * @page page_iface_wl_input_method wl_input_method
 * @section page_iface_wl_input_method_desc Description
 *
 * An input method object is responsible to compose text in response to
 * input from hardware or virtual keyboards. There is one input method
 * object per seat. On activate there is a new input method context object
 * created which allows the input method to communicate with the text model.
 * @section page_iface_wl_input_method_api API
 * See @ref iface_wl_input_method.
 */
/**
 * @defgroup iface_wl_input_method The wl_input_method interface
 *
 * An input method object is responsible to compose text in response to
 * input from hardware or virtual keyboards. There is one input method
 * object per seat. On activate there is a new input method context object
 * created which allows the input method to communicate with the text model.
 */
extern const struct wl_interface wl_input_method_interface;
#endif
#ifndef WL_INPUT_PANEL_INTERFACE
#define WL_INPUT_PANEL_INTERFACE
/**
 * @page page_iface_wl_input_panel wl_input_panel
 * @section page_iface_wl_input_panel_desc Description
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_wl_input_panel_api API
 * See @ref iface_wl_input_panel.
 */
/**
 * @defgroup iface_wl_input_panel The wl_input_panel interface
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface wl_input_panel_interface;
#endif
#ifndef WL_INPUT_PANEL_SURFACE_INTERFACE
#define WL_INPUT_PANEL_SURFACE_INTERFACE
/**
 * @page page_iface_wl_input_panel_surface wl_input_panel_surface
 * @section page_iface_wl_input_panel_surface_api API
 * See @ref iface_wl_input_panel_surface.
 */
/**
 * @defgroup iface_wl_input_panel_surface The wl_input_panel_surface interface
 */
extern const struct wl_interface wl_input_panel_surface_interface;
#endif

/**
 * @ingroup iface_wl_input_method_context
 * @struct wl_input_method_context_interface
 */
struct wl_input_method_context_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * commit string
	 *
	 * Send the commit string text for insertion to the application.
	 *
	 * The text to commit could be either just a single character after
	 * a key press or the result of some composing (pre-edit). It could
	 * be also an empty text when some text should be removed (see
	 * delete_surrounding_text) or when the input cursor should be
	 * moved (see cursor_position).
	 *
	 * Any previously set composing text will be removed.
	 * @param serial serial of the latest known text input state
	 */
	void (*commit_string)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t serial,
			      const char *text);
	/**
	 * pre-edit string
	 *
	 * Send the pre-edit string text to the application text input.
	 *
	 * The commit text can be used to replace the preedit text on reset
	 * (for example on unfocus).
	 *
	 * Also previously sent preedit_style and preedit_cursor requests
	 * are processed bt the text_input also.
	 * @param serial serial of the latest known text input state
	 */
	void (*preedit_string)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t serial,
			       const char *text,
			       const char *commit);
	/**
	 * pre-edit styling
	 *
	 * Sets styling information on composing text. The style is
	 * applied for length in bytes from index relative to the beginning
	 * of the composing text (as byte offset). Multiple styles can be
	 * applied to a composing text.
	 *
	 * This request should be sent before sending preedit_string
	 * request.
	 */
	void (*preedit_styling)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t index,
				uint32_t length,
				uint32_t style);
	/**
	 * pre-edit cursor
	 *
	 * Sets the cursor position inside the composing text (as byte
	 * offset) relative to the start of the composing text.
	 *
	 * When index is negative no cursor should be displayed.
	 *
	 * This request should be sent before sending preedit_string
	 * request.
	 */
	void (*preedit_cursor)(struct wl_client *client,
			       struct wl_resource *resource,
			       int32_t index);
	/**
	 * delete text
	 *
	 * 
	 *
	 * This request will be handled on text_input side as part of a
	 * directly following commit_string request.
	 */
	void (*delete_surrounding_text)(struct wl_client *client,
					struct wl_resource *resource,
					int32_t index,
					uint32_t length);
	/**
	 * set cursor to a new position
	 *
	 * Sets the cursor and anchor to a new position. Index is the new
	 * cursor position in bytess (when >= 0 relative to the end of
	 * inserted text else relative to beginning of inserted text).
	 * Anchor is the new anchor position in bytes (when >= 0 relative
	 * to the end of inserted text, else relative to beginning of
	 * inserted text). When there should be no selected text anchor
	 * should be the same as index.
	 *
	 * This request will be handled on text_input side as part of a
	 * directly following commit_string request.
	 */
	void (*cursor_position)(struct wl_client *client,
				struct wl_resource *resource,
				int32_t index,
				int32_t anchor);
	/**
	 */
	void (*modifiers_map)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_array *map);
	/**
	 * keysym
	 *
	 * Notify when a key event was sent. Key events should not be
	 * used for normal text input operations, which should be done with
	 * commit_string, delete_surrounfing_text, etc. The key event
	 * follows the wl_keyboard key event convention. Sym is a XKB
	 * keysym, state a wl_keyboard key_state.
	 * @param serial serial of the latest known text input state
	 */
	void (*keysym)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t serial,
		       uint32_t time,
		       uint32_t sym,
		       uint32_t state,
		       uint32_t modifiers);
	/**
	 * grab hardware keyboard
	 *
	 * Allows an input method to receive hardware keyboard input and
	 * process key events to generate text events (with pre-edit) over
	 * the wire. This allows input methods which compose multiple key
	 * events for inputting text like it is done for CJK languages.
	 */
	void (*grab_keyboard)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t keyboard);
	/**
	 * forward key event
	 *
	 * Should be used when filtering key events with grab_keyboard.
	 *
	 * When the wl_keyboard::key event is not processed by the input
	 * method itself and should be sent to the client instead, forward
	 * it with this request. The arguments should be the ones from the
	 * wl_keyboard::key event.
	 *
	 * For generating custom key events use the keysym request instead.
	 * @param serial serial from wl_keyboard::key
	 * @param time time from wl_keyboard::key
	 * @param key key from wl_keyboard::key
	 * @param state state from wl_keyboard::key
	 */
	void (*key)(struct wl_client *client,
		    struct wl_resource *resource,
		    uint32_t serial,
		    uint32_t time,
		    uint32_t key,
		    uint32_t state);
	/**
	 * forward modifiers event
	 *
	 * Should be used when filtering key events with grab_keyboard.
	 *
	 * When the wl_keyboard::modifiers event should be also send to the
	 * client, forward it with this request. The arguments should be
	 * the ones from the wl_keyboard::modifiers event.
	 * @param serial serial from wl_keyboard::modifiers
	 * @param mods_depressed mods_depressed from wl_keyboard::modifiers
	 * @param mods_latched mods_latched from wl_keyboard::modifiers
	 * @param mods_locked mods_locked from wl_keyboard::modifiers
	 * @param group group from wl_keyboard::modifiers
	 */
	void (*modifiers)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t serial,
			  uint32_t mods_depressed,
			  uint32_t mods_latched,
			  uint32_t mods_locked,
			  uint32_t group);
	/**
	 * @param serial serial of the latest known text input state
	 */
	void (*language)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t serial,
			 const char *language);
	/**
	 * @param serial serial of the latest known text input state
	 */
	void (*text_direction)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t serial,
			       uint32_t direction);
};

#define WL_INPUT_METHOD_CONTEXT_SURROUNDING_TEXT 0
#define WL_INPUT_METHOD_CONTEXT_RESET 1
#define WL_INPUT_METHOD_CONTEXT_CONTENT_TYPE 2
#define WL_INPUT_METHOD_CONTEXT_INVOKE_ACTION 3
#define WL_INPUT_METHOD_CONTEXT_COMMIT_STATE 4
#define WL_INPUT_METHOD_CONTEXT_PREFERRED_LANGUAGE 5

/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_RESET_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_CONTENT_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_INVOKE_ACTION_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_COMMIT_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_PREFERRED_LANGUAGE_SINCE_VERSION 1

/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_COMMIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_PREEDIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_PREEDIT_STYLING_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_PREEDIT_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_DELETE_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_CURSOR_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_MODIFIERS_MAP_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_KEYSYM_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_GRAB_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_MODIFIERS_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_LANGUAGE_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method_context
 */
#define WL_INPUT_METHOD_CONTEXT_TEXT_DIRECTION_SINCE_VERSION 1

/**
 * @ingroup iface_wl_input_method_context
 * Sends an surrounding_text event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_context_send_surrounding_text(struct wl_resource *resource_, const char *text, uint32_t cursor, uint32_t anchor)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_CONTEXT_SURROUNDING_TEXT, text, cursor, anchor);
}

/**
 * @ingroup iface_wl_input_method_context
 * Sends an reset event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_context_send_reset(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_CONTEXT_RESET);
}

/**
 * @ingroup iface_wl_input_method_context
 * Sends an content_type event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_context_send_content_type(struct wl_resource *resource_, uint32_t hint, uint32_t purpose)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_CONTEXT_CONTENT_TYPE, hint, purpose);
}

/**
 * @ingroup iface_wl_input_method_context
 * Sends an invoke_action event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_context_send_invoke_action(struct wl_resource *resource_, uint32_t button, uint32_t index)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_CONTEXT_INVOKE_ACTION, button, index);
}

/**
 * @ingroup iface_wl_input_method_context
 * Sends an commit_state event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial of text input state
 */
static inline void
wl_input_method_context_send_commit_state(struct wl_resource *resource_, uint32_t serial)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_CONTEXT_COMMIT_STATE, serial);
}

/**
 * @ingroup iface_wl_input_method_context
 * Sends an preferred_language event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_context_send_preferred_language(struct wl_resource *resource_, const char *language)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_CONTEXT_PREFERRED_LANGUAGE, language);
}

#define WL_INPUT_METHOD_ACTIVATE 0
#define WL_INPUT_METHOD_DEACTIVATE 1

/**
 * @ingroup iface_wl_input_method
 */
#define WL_INPUT_METHOD_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_method
 */
#define WL_INPUT_METHOD_DEACTIVATE_SINCE_VERSION 1


/**
 * @ingroup iface_wl_input_method
 * Sends an activate event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_send_activate(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_ACTIVATE, id);
}

/**
 * @ingroup iface_wl_input_method
 * Sends an deactivate event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wl_input_method_send_deactivate(struct wl_resource *resource_, struct wl_resource *context)
{
	wl_resource_post_event(resource_, WL_INPUT_METHOD_DEACTIVATE, context);
}

/**
 * @ingroup iface_wl_input_panel
 * @struct wl_input_panel_interface
 */
struct wl_input_panel_interface {
	/**
	 */
	void (*get_input_panel_surface)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t id,
					struct wl_resource *surface);
};


/**
 * @ingroup iface_wl_input_panel
 */
#define WL_INPUT_PANEL_GET_INPUT_PANEL_SURFACE_SINCE_VERSION 1

#ifndef WL_INPUT_PANEL_SURFACE_POSITION_ENUM
#define WL_INPUT_PANEL_SURFACE_POSITION_ENUM
enum wl_input_panel_surface_position {
	WL_INPUT_PANEL_SURFACE_POSITION_CENTER_BOTTOM = 0,
};
#endif /* WL_INPUT_PANEL_SURFACE_POSITION_ENUM */

/**
 * @ingroup iface_wl_input_panel_surface
 * @struct wl_input_panel_surface_interface
 */
struct wl_input_panel_surface_interface {
	/**
	 * set the surface type as a keyboard
	 *
	 * A keybaord surface is only shown, when a text model is active
	 */
	void (*set_toplevel)(struct wl_client *client,
			     struct wl_resource *resource,
			     struct wl_resource *output,
			     uint32_t position);
	/**
	 * set the surface type as an overlay panel
	 *
	 * An overlay panel is shown near the input cursor above the
	 * application window when a text model is active.
	 */
	void (*set_overlay_panel)(struct wl_client *client,
				  struct wl_resource *resource);
};


/**
 * @ingroup iface_wl_input_panel_surface
 */
#define WL_INPUT_PANEL_SURFACE_SET_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_wl_input_panel_surface
 */
#define WL_INPUT_PANEL_SURFACE_SET_OVERLAY_PANEL_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
