/*
 * Copyright (c) 2020 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_USERMANAGER_H
#define SAILFISH_MDM_USERMANAGER_H

#include <QString>
#include <QDBusArgument>
#include <QDBusInterface>
#include <QObject>

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT UserManager : public QObject
{
    Q_OBJECT

public:
    struct UserEntry {
        QString user;
        QString name;
        uint uid;
    };

    explicit UserManager(QObject *parent = 0);
    virtual ~UserManager();
    QList<UserEntry> users();
    uint addUser(const QString &userLogin);
    uint addUserWithParam(const QString &userLogin, const QString &userName, uint quota);
    bool removeUser(uint uid);
    uint currentUser();
    QString currentUserUuid();
    bool setCurrentUser(uint uid);
    bool setNextSessionUser(uint uid);
    bool modifyUser(uint uid, const QString &newFullName);

    QString userUuid(uint uid);
    QStringList usersGroups(uint uid);
    bool addToGroups(uint uid, const QStringList &groups);
    bool removeFromGroups(uint uid, const QStringList &groups);

private:
    QDBusInterface *m_iface;
    Q_DISABLE_COPY(UserManager)
};
} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_USERMANAGER_H
