/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Pickers 1.0
import Sailfish.Media 1.0
import Sailfish.Gallery 1.0
import "mediaformatter.js" as MediaFormatter
import "private"

PickerPage {
    id: musicPicker

    //% "Select music"
    title: qsTrId("components_pickers-he-select_music")

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: musicPicker
    }

    MusicModel {
        id: musicModel
    }

    PickerGridView {
        id: gridView

        title: musicPicker.title
        headerPlaceholderText: qsTrId("components_pickers-ph-search_music")
        emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")
        itemModel: musicModel
        model: musicModel.model
        selectionEnabled: false
        isDialog: false
    }
}
