/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMINFO_H
#define SAILFISH_MDM_SIMINFO_H

#include <QObject>

namespace Sailfish {
namespace Mdm {
class SimInfoPrivate;

class Q_DECL_EXPORT SimInfo : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool available READ available NOTIFY availableChanged)
public:
    struct SlotInfo {
        int slot;
        QString value;

        operator const QString() const;
    };

    enum PinRequired {
        SimPinUnknown = -1,
        SimPinNotRequired = 0,
        SimPinRequired = 1,
        SimPukRequired = 2
    };

    enum NetworkRegistrationStatus {
        UnknownRegistrationStatus = -1,
        NotRegistered = 0,
        Registered,
        SearchingForRegistration,
        RegistrationDenied,
        Roaming
    };
    Q_ENUM(NetworkRegistrationStatus)

    struct SimState {
        SimState();

        QString modemPath;
        bool present;
        bool voiceSim;
        bool dataSim;
        bool enabled;
        PinRequired pinRequired; // -1 Unknown, 0 Not, 1 Pin Required, 2 Puk Required
        NetworkRegistrationStatus networkRegistrationStatus;
        QString imsi;

        QString cardIdentifier;
        QString serviceProviderName;
        QStringList subscriberNumbers;

        bool operator==(const SimState &simState) const;
        bool operator!=(const SimState &simState) const;
        bool operator>(const SimState &simState) const;
        bool operator<(const SimState &simState) const;
        bool operator>=(const SimState &simState) const;
        bool operator<=(const SimState &simState) const;
        operator const QString() const;
    };

    SimInfo(QObject *parent = 0);
    ~SimInfo();

    bool available() const;
    bool hotSwappingSupported() const;

    QList<SlotInfo> imeiCodes() const;
    QList<SlotInfo> subscriberIdentities() const; // IMSI
    QList<SlotInfo> cardIdentifier() const; // ICCID
    QList<SlotInfo> subscriberNumbers() const; // Phone numbers

    QList<SimState> simSlotStates() const;

signals:
    void availableChanged(bool available);
    void simStateChanged(const Sailfish::Mdm::SimInfo::SimState &state);

private:
    SimInfoPrivate *d_ptr;
    Q_DISABLE_COPY(SimInfo)
    Q_DECLARE_PRIVATE(SimInfo)
};
}
}
QDebug operator<<(QDebug, const Sailfish::Mdm::SimInfo::SlotInfo *) Q_DECL_EXPORT;
QDebug operator<<(QDebug dbg, const Sailfish::Mdm::SimInfo::NetworkRegistrationStatus status) Q_DECL_EXPORT;
QDebug operator<<(QDebug dbg, const Sailfish::Mdm::SimInfo::PinRequired pinRequired) Q_DECL_EXPORT;

Q_DECLARE_METATYPE(Sailfish::Mdm::SimInfo::SimState)

#endif // SAILFISH_MDM_SIMINFO_H
