#ifndef MDM_SECURITY_H
#define MDM_SECURITY_H

#include <QtGlobal>
#include <QObject>

namespace Sailfish {
namespace Mdm {

class SecuritySettingsPrivate;

class Q_DECL_EXPORT SecuritySettings: public QObject
{
    Q_OBJECT

public:
    SecuritySettings(QObject *parent = 0);
    virtual ~SecuritySettings();

    bool sideloadingAllowed();
    bool setSideloadingAllowed(bool allowed);

    bool developerModeEnabled();
    void setDeveloperModeEnabled(bool enabled);

signals:
    void developerModeEnabledChanged();
    void developerModeChangeError();

private:
    Q_DISABLE_COPY(SecuritySettings)
    SecuritySettingsPrivate *d;
};

}
}

#endif // MDM_SECURITY_H
