/*
 * Copyright (c) 2022. Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef MDM_SYSTEMDJOURNAL_H
#define MDM_SYSTEMDJOURNAL_H

#include <QObject>
#include <QDBusArgument>
#include <QDBusInterface>
#include <QString>

namespace Sailfish {
namespace Mdm {

class SystemdJournalPrivate;
class Q_DECL_EXPORT SystemdJournal : public QObject
{
    Q_OBJECT

public:
    explicit SystemdJournal(QObject *parent = nullptr);
    ~SystemdJournal() override;

    bool disableOption(const QString &option);
    QString getOption(const QString &option);
    bool setOption(const QString &option, const QString &value);

private:
    SystemdJournalPrivate *d_ptr;

    Q_DISABLE_COPY(SystemdJournal)
    Q_DECLARE_PRIVATE(SystemdJournal)
};

} // namespace Mdm
} // namespace Sailfish

#endif // MDM_SYSTEMDJOURNAL_H
