/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_AUTOSTART_H
#define SAILFISH_MDM_AUTOSTART_H

#include <QObject>
#include <QString>
#include <QStringList>

namespace Sailfish {
namespace Mdm {

class AutostartPrivate;

class Q_DECL_EXPORT Autostart : public QObject
{
    Q_OBJECT

public:

    enum Result {
        Success = 0,
        InternalError,
        InvalidDesktopFile,
        AlreadyAutostarted,
    };

    Q_ENUM(Result)

    explicit Autostart(QObject *parent = Q_NULLPTR);
    virtual ~Autostart() Q_DECL_OVERRIDE;

    Result add(const QString &desktopFilePath);
    Result remove(const QString &desktopFilePath);
    QStringList query(Autostart::Result &result);

private:

    Q_DISABLE_COPY(Autostart)
    Q_DECLARE_PRIVATE(Autostart)

    AutostartPrivate *d_ptr;

};

}
}

#endif // SAILFISH_MDM_AUTOSTART_H
