/* This file is part of the Aurora SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Online examples plugin"));
    component.setValue("Description", qsTranslate("installscript", "Download examples for Aurora OS from online repository to use in Aurora SDK"));
}

Component.prototype.createOperations = function()
{
    component.createOperations();
    var examplesRepoName = qsTranslate("installscript", "Aurora OS Examples");
    var demosRepoName = qsTranslate("installscript", "Aurora OS Demos");
    var examplesUrl = "https://hub.mos.ru/auroraos/examples";
    var demosUrl = "https://hub.mos.ru/auroraos/demos";
    component.addOperation("Settings",
                           "path=" + installer.value("QtCreatorInstallerSettingsFile"),
                           "method=add_array_value",
                           "key=OnlineExamples/Repositories",
                           "value=" + examplesRepoName + "|" + examplesUrl)
    component.addOperation("Settings",
                           "path=" + installer.value("QtCreatorInstallerSettingsFile"),
                           "method=add_array_value",
                           "key=OnlineExamples/Repositories",
                           "value=" + demosRepoName + "|" + demosUrl)

    component.addOperation("Settings",
                           "path=" + installer.value("QtCreatorInstallerSettingsFile"),
                           "method=add_array_value",
                           "key=Help/InstalledExamples",
                           "value=" + examplesRepoName)
    component.addOperation("Settings",
                           "path=" + installer.value("QtCreatorInstallerSettingsFile"),
                           "method=add_array_value",
                           "key=Help/InstalledExamples",
                           "value=" + demosRepoName)

    component.addOperation("Settings",
                           "path=" + installer.value("QtCreatorInstallerSettingsFile"),
                           "method=set",
                           "key=WelcomePage/SelectedExampleSet",
                           "value=" + examplesRepoName)
}
