/* This file is part of the Aurora SDK
*/

var virtualTargetsComponentName = "org.merproject.targets.user";
var virtualToolingsComponentName = "org.merproject.targets.user.toolings";

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Build Targets"));
    component.setValue("Description", qsTranslate("installscript", "Build toolkits for the target architecture"));

    // Mark all the user-managed toolings and targets as installed. Hide such toolings making them
    // virtual. Internationalize.
    installer.components().forEach(function(otherComponent) {
        if (otherComponent.name === virtualTargetsComponentName
            || otherComponent.name.lastIndexOf(virtualTargetsComponentName + ".", 0) === 0) {
            otherComponent.setInstalled();
            otherComponent.setValue("InstalledVersion", otherComponent.value("Version"));
        }
        if (otherComponent.name === virtualTargetsComponentName) {
            otherComponent.setValue("DisplayName", qsTranslate("installscript", "Custom Build Targets"));
            otherComponent.setValue("Description", qsTranslate("installscript", "Custom build targets managed via sfdk."));
        }
        if (otherComponent.name.lastIndexOf(virtualTargetsComponentName + ".", 0) === 0
            && otherComponent.name !== virtualToolingsComponentName) {
            otherComponent.setValue("Description",
                    qsTranslate("installscript", "This is a custom build target managed via sfdk. " +
                            "It cannot be deselected here."));
        }
    });
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    // Add virtual repository for the components representing targets installed via sfdk
    var merSdkSharedTargetsDir = installer.value("merSdkSharedTargetsDir").replace(/\\/g, '/');
    var urlPrefix = installer.value("os") === "win" ? "file:///" : "file://";
    component.addOperation("AddVirtualRepositories", urlPrefix + merSdkSharedTargetsDir + "/targets.repository");
}
