/* This file is part of the Aurora SDK
*/

// Keep the name in sync with org.merproject.targets.target!
var name = "latest" === "ea"
    ? "AuroraOS-5.2.0.75EA-aarch64"
    : "AuroraOS-5.2.0.75-aarch64";
var defaultSnapshotSuffix = "default";

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Build Target %1-%2%3 Integration for Aurora IDE")
        .arg("latest")
        .arg("aarch64")
        .arg("latest" != "5.2.0.75" ? " (5.2.0.75)" : ""));
}

Component.prototype.beginInstallation = function()
{
    var os = installer.value('os');

    if (os === "win")
        component.setStopProcessForUpdateRequest("qtcreator.exe", true);
    else if (os === "mac")
        component.setStopProcessForUpdateRequest("Qt Creator", true);
    else
        component.setStopProcessForUpdateRequest("qtcreator", true);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    addMinimalMerKit(name);
}

// We will add mer kits here to prevent Qt Creator creating a "Desktop" kit.
// These kits only contain partial information, they will be completed by
// mer plugin when first loaded.
function addMinimalMerKit(name)
{
    var sdkTool = installer.value("SDKToolBinary");
    var defaultSnapshotName = name + "." + defaultSnapshotSuffix;

    component.addOperation("Execute", 
                           ["{0,2}", sdkTool, "rmKit",
                            "--id", defaultSnapshotName,
                            ]);
    // debugger, toolchain and sysroot will be set by mer plugin
    component.addOperation("Execute", 
                           ["{0}", sdkTool, "addKit",
                            "--id", defaultSnapshotName,
                            "--name", defaultSnapshotName,
                            "--devicetype", "Mer.Device.Type",
                            "errormessage=" + qsTranslate("installscript", "Failed to add kit to Qt Creator"),
                            "UNDOEXECUTE",
                            sdkTool, "rmKit", "--id", defaultSnapshotName
                            ]);
}
