/* This file is part of the Aurora OS SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    component.setValue("DisplayName", qsTranslate("installscript", component.value("DisplayName")))
    component.setValue("Description", qsTranslate("installscript", component.value("Description")))

    generateSshKeys();
    deploySshKeys();

    registerMerSDKVMInQtCreator();

    component.registerPathForUninstallation("@merSdkSharedConfigDir@/devices.xml");
    component.registerPathForUninstallation("@merSdkSharedConfigDir@", true);
}

function registerMerSDKVMInQtCreator()
{
    var installDir = installer.value("TargetDir");
    var merSdkVmName = installer.value("merSdkVmName");
    var merSdkVmUri = installer.value("merSdkVmUri");
    var sharedMerHomeDir = installer.value("sharedMerHomeDir");
    var workspaceDir = installer.value("workspaceDir");
    var sdkTool = installer.value("SDKToolBinary");
    var errorMessage = "errormessage=" +  qsTranslate("installscript", "SdkTool: Could not remove build engine \"%1\"").arg(merSdkVmName);
    component.addOperation("Execute", ["{0,2,3}", sdkTool, "rmSfdkBuildEngine",
                                       "--vm-uri", merSdkVmUri,
                                       errorMessage
                           ]);

    component.addOperation("Execute", ["{0}", sdkTool, "addSfdkBuildEngine",
                                       "--installdir", installDir,
                                       "--vm-uri", merSdkVmUri,
                                       "--autodetected", "true",
                                       "--shared-install", installDir,
                                       "--shared-home", sharedMerHomeDir,
                                       "--shared-targets", "@merSdkSharedTargetsDir@",
                                       "--shared-ssh", "@merSdkSharedSshDir@",
                                       "--shared-config", "@merSdkSharedConfigDir@",
                                       "--shared-src", workspaceDir,
                                       "--host", "127.0.0.1",
                                       "--username", "mersdk",
                                       "--private-key-file", "@merSdkSshKeyFile@",
                                       "--ssh-port", "@merSdkVMSshPort@",
                                       "--dbus-port", "@merSdkVMDBusPort@",
                                       "--headless",
                                       "UNDOEXECUTE",
                                       "{0,1}", sdkTool, "rmSfdkBuildEngine",
                                       "--vm-uri", merSdkVmUri,
                                       errorMessage
                           ]);
}

function generateSshKeys()
{
    component.addOperation("Mkdir", "@merSdkSshKeyDir@");
    component.addOperation("Execute", ["@merSshPath@", "generatesshkeys", "'@merSdkSshKeyFile@'" ]);
    component.registerPathForUninstallation("@merSdkSshKeyFile@");
    component.registerPathForUninstallation("@merSdkSshKeyPublicFile@");
}

function deploySshKeys()
{
    var sharedSshDirMerSDK = "@merSdkSharedSshDir@/mersdk/";
    var sharedSshDirRoot = "@merSdkSharedSshDir@/root/";

    component.addOperation("Mkdir", sharedSshDirMerSDK);
    component.addOperation("Mkdir", sharedSshDirRoot);

    var authorizedKeysBaseName = "authorized_keys";
    component.addOperation("Copy", "@merSdkSshKeyPublicFile@", sharedSshDirRoot + authorizedKeysBaseName);
    component.addOperation("Copy", "@merSdkSshKeyPublicFile@", sharedSshDirMerSDK + authorizedKeysBaseName);
}
