// SPDX-FileCopyrightText: 2019-2020 Jolla Ltd.
// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

namespace Sfdk {
namespace Constants {

const char APPLICATION_NAME[] = "Aurora OS SDK";

const char LIB_ID[] = "libsfdk";

const int DEFAULT_QML_LIVE_PORT = 10234;
const int MAX_PORT_LIST_PORTS = 10;

const char VIRTUAL_MACHINE_URI_SCHEME[] = "sfdkvm";

const char BUILD_ENGINES_SETTINGS_FILE_NAME[] = "buildengines.xml";
// "QtCreator" prefix is enforced by sdktool
const char BUILD_ENGINES_SETTINGS_DOC_TYPE[] = "QtCreatorSfdkBuildEngines";
const char BUILD_ENGINES_VERSION_KEY[] = "BuildEngines.Version";
const char BUILD_ENGINES_INSTALL_DIR_KEY[] = "BuildEngines.InstallDir";
const char BUILD_ENGINES_CUSTOM_BUILD_HOST_NAME_KEY[] = "BuildEngines.CustomBuildHostName";
const char BUILD_ENGINES_BUILD_ENVIRONMENT_FILTER_KEY[] = "BuildEngines.BuildEnvironmentFilter";
const char BUILD_ENGINES_DOCKER_BRIDGE_ADDRES[] = "BuildEngines.DockerBridgeAddres";
const char BUILD_ENGINES_COUNT_KEY[] = "BuildEngines.Count";
const char BUILD_ENGINES_DATA_KEY_PREFIX[] = "BuildEngine.";
const char BUILD_ENGINE_VM_URI[] = "VirtualMachineUri";
const char BUILD_ENGINE_CREATION_TIME[] = "CreationTime";
const char BUILD_ENGINE_AUTODETECTED[] = "Autodetected";
const char BUILD_ENGINE_SHARED_INSTALL[] = "SharedInstall";
const char BUILD_ENGINE_SHARED_HOME[] = "SharedHome";
const char BUILD_ENGINE_SHARED_TARGET[] = "SharedTarget";
const char BUILD_ENGINE_SHARED_CONFIG[] = "SharedConfig";
const char BUILD_ENGINE_SHARED_SRC[] = "SharedSrc";
const char BUILD_ENGINE_SHARED_SSH[] = "SharedSsh";
const char BUILD_ENGINE_HOST[] = "Host";
const char BUILD_ENGINE_USER_NAME[] = "UserName";
const char BUILD_ENGINE_PRIVATE_KEY_FILE[] = "PrivateKeyFile";
const char BUILD_ENGINE_SSH_PORT[] = "SshPort";
const char BUILD_ENGINE_SSH_TIMEOUT[] = "SshTimeout";
const char BUILD_ENGINE_DBUS_PORT[] = "DBusPort";
const char BUILD_ENGINE_WWW_PROXY_TYPE[] = "WwwProxyType";
const char BUILD_ENGINE_WWW_PROXY_SERVERS[] = "WwwProxyServers";
const char BUILD_ENGINE_WWW_PROXY_EXCLUDES[] = "WwwProxyExcludes";
const char BUILD_ENGINE_HEADLESS[] = "Headless";
const char BUILD_ENGINE_TARGETS_COUNT_KEY[] = "BuildTargets.Count";
const char BUILD_ENGINE_TARGET_DATA_KEY_PREFIX[] = "BuildTarget.";
const char BUILD_ENGINE_SHARED_INSTALL_MOUNT_POINT[] = "/host_install";
const char BUILD_ENGINE_SHARED_CONFIG_MOUNT_POINT[] = "/etc/mersdk/share";
const char BUILD_ENGINE_SHARED_HOME_MOUNT_POINT[] = "/host_home";
const char BUILD_ENGINE_SHARED_TARGET_MOUNT_POINT[] = "/host_targets";
const char BUILD_ENGINE_SHARED_SSH_MOUNT_POINT[] = "/etc/ssh/authorized_keys";
const char BUILD_ENGINE_ALIGNED_MOUNT_POINT_ENV_TEMPLATE[] = "SAILFISH_SDK_%1_MOUNT_POINT";
const char BUILD_ENGINE_HOST_GNUPG_PATH_POSTFIX[] = "/gnupg";
const char BUILD_ENGINE_HOST_SECCOMP_PATH_POSTFIX[] = "/mersdk/seccomp.json";

const char BUILD_TARGET_NAME[] = "Name";
const char BUILD_TARGET_ORIGIN[] = "Origin";
const char BUILD_TARGET_GCC_DUMP_MACHINE[] = "GccDumpMachine";
const char BUILD_TARGET_GCC_DUMP_MACROS[] = "GccDumpMacros";
const char BUILD_TARGET_GCC_DUMP_INCLUDES[] = "GccDumpIncludes";
const char BUILD_TARGET_GCC_DUMP_INSTALL_DIR[] = "GccDumpInstallDir";
const char BUILD_TARGET_QMAKE_QUERY[] = "QmakeQuery";
const char BUILD_TARGET_CMAKE_CAPABILITIES[] = "CMakeCapabilities";
const char BUILD_TARGET_CMAKE_VERSION[] = "CMakeVersion";
const char BUILD_TARGET_RPM_VALIDATION_SUITES[] = "RpmValidationSuites";
const char BUILD_TARGET_RPM_SIGN_UTILS[] = "RpmSignUtils";

#ifdef Q_OS_WIN
#define SCRIPT_EXTENSION ".cmd"
#else
#define SCRIPT_EXTENSION ""
#endif

const char BUILD_TARGET_TOOLS[] = "build-target-tools";
const char WRAPPER_CMAKE[] = "cmake" SCRIPT_EXTENSION;
const char WRAPPER_QMAKE[] = "qmake" SCRIPT_EXTENSION;
const char WRAPPER_MAKE[] = "make" SCRIPT_EXTENSION;
const char WRAPPER_GCC[] = "gcc" SCRIPT_EXTENSION;
const char WRAPPER_PKG_CONFIG[] = "pkg-config" SCRIPT_EXTENSION;
const char QMAKE_QUERY_CACHE[] = "qmake.query";
const char CMAKE_CAPABILITIES_CACHE[] = "cmake.capabilities";
const char CMAKE_VERSION_CACHE[] = "cmake.version";
const char GCC_DUMP_MACHINE_CACHE[] = "gcc.dumpmachine";
const char GCC_DUMP_MACROS_CACHE[] = "gcc.dumpmacros";
const char GCC_DUMP_INCLUDES_CACHE[] = "gcc.dumpincludes";
const char GCC_DUMP_INSTALL_DIR_CACHE[] = "gcc.dumpinstalldir";

#undef SCRIPT_EXTENSION

// FIXME
const char MER_SSH_SDK_TOOLS[] = "MER_SSH_SDK_TOOLS";

const char WWW_PROXY_DISABLED[] = "direct";
const char WWW_PROXY_AUTOMATIC[] = "auto";
const char WWW_PROXY_MANUAL[] = "manual";

const char X86_64_IDENTIFIER[] = "x86_64";
const char i486_IDENTIFIER[] = "i486";
const char ARM_IDENTIFIER[] = "arm";
const char AARCH64_IDENTIFIER[] = "aarch64";

const char DEFAULT_DEBUGGER_i486_FILENAME[] = "gdb-i486-meego-linux-gnu";
const char DEFAULT_DEBUGGER_x86_64_FILENAME[] = "gdb-x86_64-meego-linux-gnu";
const char DEFAULT_DEBUGGER_ARM_FILENAME[] = "gdb-armv7hl-meego-linux-gnueabi";
const char DEFAULT_DEBUGGER_AARCH64_FILENAME[] = "gdb-aarch64-meego-linux-gnu";
const char DEBUGGER_FILENAME_PREFIX[] = "gdb-";

// hardcoded IPv4 address to prevent connecting via IPv6
const char BUILD_ENGINE_DEFAULT_HOST[] = "127.0.0.1";
const char BUILD_ENGINE_DEFAULT_USER_NAME[] = "mersdk";
const int BUILD_ENGINE_DEFAULT_SSH_TIMEOUT = 30;

const char EMULATORS_SETTINGS_FILE_NAME[] = "emulators.xml";
// "QtCreator" prefix is enforced by sdktool
const char EMULATORS_SETTINGS_DOC_TYPE[] = "QtCreatorSfdkEmulators";
const char EMULATORS_VERSION_KEY[] = "Emulators.Version";
const char EMULATORS_INSTALL_DIR_KEY[] = "Emulators.InstallDir";
const char EMULATORS_COUNT_KEY[] = "Emulators.Count";
const char EMULATORS_DATA_KEY_PREFIX[] = "Emulator.";
const char EMULATOR_PRODUCT_NAME[] = "ProductName";
const char EMULATOR_PRODUCT_RELEASE[] = "ProductRelease";
const char EMULATOR_VM_URI[] = "VirtualMachineUri";
const char EMULATOR_CREATION_TIME[] = "CreationTime";
const char EMULATOR_AUTODETECTED[] = "Autodetected";
const char EMULATOR_SHARED_CONFIG[] = "SharedConfig";
const char EMULATOR_SHARED_SSH[] = "SharedSsh";
const char EMULATOR_SHARED_MEDIA[] = "SharedMedia";
const char EMULATOR_HOST[] = "Host";
const char EMULATOR_USER_NAME[] = "UserName";
const char EMULATOR_PRIVATE_KEY_FILE[] = "PrivateKeyFile";
const char EMULATOR_SSH_PORT[] = "SshPort";
const char EMULATOR_SSH_TIMEOUT[] = "SshTimeout";
const char EMULATOR_FREE_PORTS[] = "FreePorts";
const char EMULATOR_QML_LIVE_PORTS[] = "QmlLivePorts";
const char EMULATOR_FACTORY_SNAPSHOT[] = "FactorySnapshot";
const char EMULATOR_MAC[] = "Mac";
const char EMULATOR_SUBNET[] = "Subnet";
const char EMULATOR_DEVICE_MODEL[] = "DeviceModel";
const char EMULATOR_ORIENTATION[] = "Orientation";
const char EMULATOR_VIEW_SCALED[] = "ViewScaled";

const char DEVICE_MODELS_COUNT_KEY[] = "DeviceModels.Count";
const char DEVICE_MODELS_DATA_KEY_PREFIX[] = "DeviceModel.";
const char DEVICE_MODEL_NAME[] = "Name";
const char DEVICE_MODEL_AUTODETECTED[] = "Autodetected";
const char DEVICE_MODEL_DISPLAY_RESOLUTION[] = "DisplayResolution";
const char DEVICE_MODEL_DISPLAY_SIZE[] = "DisplaySize";
const char DEVICE_MODEL_DCONF[] = "Dconf";

// hardcoded IPv4 address to prevent connecting via IPv6
const char EMULATOR_DEFAULT_HOST[] = "127.0.0.1";
const char EMULATOR_DEFAULT_USER_NAME[] = "defaultuser";
const int EMULATOR_DEFAULT_SSH_TIMEOUT = 30;

const char VIRTUAL_BOX_VIRTUAL_SUBNET[] = "10.220.220";

const char EMULATOR_COMPOSITOR_CONFIG_FILENAME[] = "60-emul-wayland-ui.conf";
const char EMULATOR_COMPOSITOR_SCALE_CONFIG_FILENAME[] = "65-emul-wayland-ui-scale.conf";
const char EMULATOR_DCONF_DB_FILENAME[] = "device-model.txt";
const char EMULATOR_QEMU_TOUCH_RULES_FILENAME[] = "99-qemu-touch.rules";

const char DEVICES_SETTINGS_FILE_NAME[] = "devices.xml";
// Here "QtCreator" prefix is used just for consistency with other doc types,
// where it is enforced by sdktool
const char DEVICES_SETTINGS_DOC_TYPE[] = "QtCreatorSfdkDevices";
const char DEVICES_COUNT_KEY[] = "Devices.Count";
const char DEVICES_DATA_KEY_PREFIX[] = "Device.";
const char DEVICE_ID[] = "Id";
const char DEVICE_NAME[] = "Name";
const char DEVICE_AUTODETECTED[] = "Autodetected";
const char DEVICE_ARCHITECTURE[] = "Architecture";
const char DEVICE_WORD_WIDTH[] = "WordWidth";
const char DEVICE_MACHINE_TYPE[] = "MachineType";

// Just for loading old configs
const unsigned char DEVICE_FALLBACK_WORD_WIDTH = 32;

const char HARDWARE_DEVICE_HOST[] = "Host";
const char HARDWARE_DEVICE_PORT[] = "Port";
const char HARDWARE_DEVICE_USER_NAME[] = "UserName";
const char HARDWARE_DEVICE_AUTHENTICATION_TYPE[] = "AuthenticationType";
const char HARDWARE_DEVICE_PRIVATE_KEY_FILE[] = "PrivateKeyFile";
const char HARDWARE_DEVICE_TIMEOUT[] = "Timeout";
const char HARDWARE_DEVICE_HOST_KEY_CHECKING[] = "HostKeyChecking";
const char HARDWARE_DEVICE_FREE_PORTS[] = "FreePorts";
const char HARDWARE_DEVICE_QML_LIVE_PORTS[] = "QmlLivePorts";

const char EMULATOR_DEVICE_EMULATOR_URI[] = "EmulatorUri";

} // namespace Constants
} // namespace Sfdk
