/*
 * SPDX-FileCopyrightText: 2018-2020 Jolla Ltd
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_NETWORKDATACOUNTER_P_H
#define SAILFISH_MDM_NETWORKDATACOUNTER_P_H

#include <QObject>
#include <QDBusInterface>

namespace Sailfish {
namespace Mdm {

class NetworkDataCounter;
class NetworkDataCounterPrivate : public QObject
{
    Q_OBJECT

public:
    NetworkDataCounterPrivate(NetworkDataCounter *parent);
    ~NetworkDataCounterPrivate();

private slots:
    void onUpdateIntervalChanged(uint id);
    void onUpdateAccuracyChanged(uint id);
    void onActiveChanged(uint id);
    void onCounterUpdate(uint id, const QVariantMap &update);

public:
    QDBusInterface iface;
    uint id;
    NetworkDataCounter *q;
};

}
}

#endif // SAILFISH_MDM_NETWORKDATACOUNTER_H
