/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_CERTIFICATE_P_H
#define SAILFISH_MDM_CERTIFICATE_P_H

#include "mdm-certificate.h"
#include "base-mdm-proxy-interface_p.h"

#include <QDBusInterface>
#include <QVariantMap>
#include <QSslCertificate>

namespace Sailfish {
namespace Mdm {

class CertificateFilePrivate : public QSharedData
{
public:
    CertificateFilePrivate(const QString &name, const QList<QSslCertificate> &certs);
    CertificateFilePrivate(const CertificateFilePrivate &file) = default;

    QString name;
    QList<QSslCertificate> certs;
};

class CertificatesPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT

public:
    using ErrorType = Certificates::ErrorType;

    CertificatesPrivate(Certificates *parent);
    ~CertificatesPrivate() override;

    CertificateFile getCertFile(const QVariantMap &params);
    QList<CertificateFile> getCertFiles(const QList<QVariantMap> &files);

public slots:
    void onInstallFinished(const QVariantMap &file, bool result);
    void onUninstallFinished(const QVariantMap &file, bool result);
    void onBlacklistFinished(const QVariantMap &file, bool result);
    void onUnblacklistFinished(const QVariantMap &file, bool result);

public:
    QDBusInterface iface;
    ErrorType lastError = ErrorType::NoError;
    Certificates *q_ptr;
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_CERTIFICATE_P_H
