/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

namespace {

enum ErrorType : int {
    NoError,
    InvalidCommand,
    InvalidFileName,
    EmptyFile,
    FileAlreadyExist,
    CantOpenFile,
    CantWriteFile,
    FailedVerify,
    FailedFinalizeFile,
    UpdateCaTrusIssue,
    DBusError,
    ErrorDecode,
    ErrorPassphrase,
    InvalidId,
    NoActiveUser,
};

namespace Key {

const auto FileName = QStringLiteral("FileName");
const auto Certs = QStringLiteral("Certs");
const auto Id = QStringLiteral("Id");
const auto Cert = QStringLiteral("Cert");

} // namespace Key

} // anonymous namespace
