/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */
import QtQuick 2.6
import Sailfish.Silica 1.0
import Nemo.FileManager 1.0

CreateArchiveDialog {
    property bool passwordError
    property string destinationPageName
    readonly property var __destinationPage: pageStack.find(function(dialog) { return dialog.hasOwnProperty(destinationPageName) })

    objectName: "ArchivePasswordDialog"
    acceptDestination: destinationPageName.length > 0 ? __destinationPage : __directory_page
    archiveFileName: extractorView.model.fileName
    passwordDialogMode: true
    //% "Incorrect password"
    passwordErrorLabel: passwordError ? qsTrId("filemanager-la-incorrect_password") : ""
}
