/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import QtGraphicalEffects 1.0

Item {
    id: root

    property alias iconSource: detailIcon.source
    property alias backgroundRadius: background.radius
    property alias backgroundWidth: background.width
    property alias backgroundHeight: background.height

    width: backgroundWidth
    height: backgroundHeight

    Rectangle {
        id: background

        anchors.horizontalCenter: parent.horizontalCenter

        layer.enabled: true
        layer.effect: OpacityMask {
            source: background
            maskSource: Rectangle {
                width: background.width
                height: background.height
                radius: background.radius
            }
        }

        gradient: Gradient {
            GradientStop { position: 0.0; color: Theme.rgba(Theme.primaryColor, 0.15) }
            GradientStop { position: 1.0; color: "transparent" }
        }

        Icon {
            id: detailIcon

            objectName: "FolderIcon"
            anchors.centerIn: parent
        }
    }
}
