/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2022-2024 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: BSD 3-Clause
**
****************************************************************************************/

import QtQuick 2.2
import Sailfish.Silica 1.0

Item {
    id: root

    anchors.left: internal.currentItem ? internal.currentItem.left : undefined
    opacity: enabled || progress > 0 ? 1.0 : 0.0

    property bool enabled
    property real progress

    signal clicked
    signal anchorChanged

    onProgressChanged: {
        if (mouseArea.containsMouse) {
            return
        }

        if (indicatorAnimation.running) {
            if (indicator.progress > progress) {
                return
            }
            indicatorAnimation.stop()
        }

        if (progress == 0 && indicator.progress == 1) {
            enabled = false
        }
        if (progress == 0 && indicator.progress > 0.1) {
            indicatorAnimation.to = 0
            indicatorAnimation.restart()
            return
        }

        indicator.progress = progress
    }

    Behavior on opacity {
        FadeAnimation {
            id: opacityAnimation
            onRunningChanged: {
                if (!running) {
                    root.anchorTo(internal.pendingItem)
                }
            }
        }
    }

    function anchorTo(item, immediate) {
        internal.pendingItem = item
        if ((opacityAnimation.running || enabled == true) && !immediate ) {
            if (item != null || root.progress == 0) {
                enabled = item === internal.currentItem
            }
        } else {
            internal.currentItem = item
            root.anchorChanged()
            enabled = item !== null
        }
    }

    QtObject {
        id: internal
        property Item pendingItem
        property Item currentItem
    }

    SafeZoneTracker {
        width: Theme.pageStackIndicatorWidth
        height: Theme._itemSizeHeader

        PageStackChevronIndicator {
            id: indicator

            onProgressChanged: {
                if (indicatorAnimation.running) {
                    if (progress > root.progress) {
                        return
                    }
                    indicatorAnimation.stop()
                }
            }

            anchors.centerIn: parent
            anchors.horizontalCenterOffset: Theme.dp(3)
            compact: true
        }

        NumberAnimation {
            id: indicatorAnimation

            target: indicator
            property: "progress"
            duration: 200
            easing.type: Easing.InOutQuart
        }

        MouseArea {
            id: mouseArea

            onContainsMouseChanged: {
                if (containsMouse) {
                    indicatorAnimation.to = 1
                    indicatorAnimation.restart()
                    return
                }

                indicatorAnimation.to = progress
                indicatorAnimation.restart()
            }
            onClicked: root.clicked()

            anchors.fill: parent
        }
    }
}
