/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2022-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (C) 2017 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jolla.com>
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0

DialogHeader {
    id: header

    property bool showBack
    property bool singleSelectionMode
    property int selectedCount
    property bool fileSystemAccepted
    readonly property bool largeScreen: Screen.sizeCategory > Screen.Medium

    //: Dialog header cancel text as "Back"
    //% "Back"
    cancelText: showBack ? qsTrId("components_pickers-he-multiselect_dialog_back") : defaultCancelText
    spacing: Theme.paddingMedium
    acceptText: {
        var text = dialog.acceptText.length ? dialog.acceptText : defaultAcceptText
        if (singleSelectionMode) {
            return text
        } else {
            //: Multi content picker number of selected content items
            //% "Accept %n"
            return selectedCount ? qsTrId("components_pickers-he-multipicker_attach", selectedCount) : text
        }
    }
}
