/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2022-2023 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: BSD 3-Clause
**
****************************************************************************************/

import QtQuick 2.2
import Sailfish.Silica 1.0

SafeZoneTracker {
    id: root

    z: 1
    width: Theme.pageStackIndicatorWidth
    height: Theme._itemSizeHeader
    opacity: enabled || progress > 0 ? 1.0 : 0.0

    property bool enabled: false
    property real progress

    signal clicked

    onProgressChanged: {
        if (mouseArea.containsMouse) {
            return
        }

        if (indicatorAnimation.running) {
            if (indicator.progress > progress) {
                return
            }
            indicatorAnimation.stop()
        }

        if (progress == 0 && indicator.progress == 1) {
            enabled = false
        }
        if (progress == 0 && indicator.progress > 0.1) {
            indicatorAnimation.to = 0
            indicatorAnimation.restart()
            return
        }

        indicator.progress = progress
    }

    Behavior on opacity {
        FadeAnimation {
            id: opacityAnimation
            onRunningChanged: {
                if (!running) {
                    root.setParent(internal.pendingParent)
                }
            }
        }
    }

    function setParent(item, immediate) {
        internal.pendingParent = item
        if ((opacityAnimation.running || enabled == true) && !immediate ) {
            if (item != null || root.progress == 0) {
                enabled = item === root.parent
            }
        } else {
            root.parent = item
            enabled = true
        }
    }

    QtObject {
        id: internal
        property Item pendingParent: null
    }

    Item {
        y: root.safeZoneRect.y
        x: root.safeZoneRect.x
        width: root.width
        height: root.height

        PageStackChevronIndicator {
            id: indicator

            onProgressChanged: {
                if (indicatorAnimation.running) {
                    if (progress > root.progress) {
                        return
                    }
                    indicatorAnimation.stop()
                }
            }

            anchors.centerIn: parent
            anchors.horizontalCenterOffset: Theme.dp(3)
            compact: true
        }

        NumberAnimation {
            id: indicatorAnimation

            target: indicator
            property: "progress"
            duration: 200
            easing.type: Easing.InOutQuart

            onRunningChanged: {
                if (!running && progress == 0) {
                    root.setParent(internal.pendingParent)
                }
            }
        }

        MouseArea {
            id: mouseArea

            onContainsMouseChanged: {
                if (containsMouse) {
                    indicatorAnimation.to = 1
                    indicatorAnimation.restart()
                    return
                }

                indicatorAnimation.to = progress
                indicatorAnimation.restart()
            }
            onClicked: root.clicked()

            anchors.fill: parent
        }
    }
}
