/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

Item {
    id: errorItem

    anchors {
        verticalCenter: parent.verticalCenter
        left: parent.left
        leftMargin: Theme.paddingLarge
        right: parent.right
        rightMargin: anchors.leftMargin
    }

    Image {
        id: errorIcon

        anchors {
            horizontalCenter: parent.horizontalCenter
            top: errorItem.top
        }

        source: "image://theme/icon-m-file-damaged"
    }

    Label {
        id: errorHeader

        anchors {
            top: errorIcon.bottom
            topMargin: Theme.paddingLarge
            left: parent.left
            right: parent.right
        }

        //% "Can't open the file"
        text: qsTrId("components_gallery-la-image-loading-failed")

        horizontalAlignment: Text.AlignHCenter
        wrapMode: Text.WordWrap
        font.pixelSize: Theme.fontSizeLarge
    }

    Label {
        anchors {
            top: errorHeader.bottom
            topMargin: Theme.paddingSmall
            left: parent.left
            right: parent.right
        }

        //% "The file may have been moved, deleted, or its name and path are incorrect."
        text: qsTrId("components_gallery-la-image-loading-failed-reason")

        opacity: Theme.opacityOverlay
        horizontalAlignment: Text.AlignHCenter
        wrapMode: Text.WordWrap
        font.pixelSize: Theme.fontSizeSmall
    }

    Behavior on opacity { FadeAnimator {}}
}
