/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (C) 2017 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Pickers 1.0
import "private"

ContentPickerPageBase {
    //% "Select downloads"
    title: qsTrId("components_pickers-he-select_downloads")


    _contentModel: DocumentModel {
        contentFilter: GalleryStartsWithFilter {
            property: "filePath"
            value: StandardPaths.download
        }
        contentType: ContentType.File
        rootType: DocumentGallery.File
    }

    //: Placeholder text of downloads search field in content picker
    //% "Search downloads"
    _searchPlaceholderText: qsTrId("components_pickers-ph-search_downloads")
}
