/****************************************************************************
**
** Copyright (c) 2013 - 2019 Jolla Ltd.
** Copyright (c) 2019 - 2022 Open Mobile Platform LLC.
**
****************************************************************************/

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

import QtQuick 2.1
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import MeeGo.QOfono 0.2

Item {
    id: root

    property bool selectionVisible
    readonly property bool active: selectionVisible

    property string text
    property string searchUri
    property bool isPhoneNumber

    readonly property bool _canCall: cellular1Status.registered || cellular2Status.registered

    property bool _phoneNumberSelected

    // Keeping for backwards compatibility
    property bool contentWidth
    property bool contentHeight
    property QtObject contentItem

    function copy() {}
    function swap() {
        // Should we implement this?
        // Feels rather good this way as well.
    }

    function getMarkerBaseMessage(markerTag) {
        return {
            change: markerTag,
            start: { xPos: 0, yPos: 0 },
            end:   { xPos: 0, yPos: 0 },
            caret: { xPos: 0, yPos: 0 },
        }
    }

    function selectionRangeUpdated(data) {
        selectionVisible = true

        text = data.text || ""
        searchUri = data.searchUri || ""

        _phoneNumberSelected = data.isPhoneNumber
        isPhoneNumber = _canCall && _phoneNumberSelected
    }

    function selectAll() {
        contentItem.sendAsyncMessage("Browser:SelectionSelectAll", { })
    }

    function showNotification() {
            notification.show()
    }

    function selectionInactiveHandler() {
        selectionVisible = false
        notification.published = false
        root.destroy()
    }

    function clearSelection() {
        contentItem.sendAsyncMessage("Browser:SelectionClose", { "clearSelection": true })
    }

    on_CanCallChanged: {
        isPhoneNumber = _canCall && _phoneNumberSelected
    }

    Private.VirtualKeyboardObserver {
        id: virtualKeyboardObserver
        active: root.active
        orientation: contentItem.orientation
    }

    Notice {
        id: notification

        duration: 3000

        //% "Copied to clipboard"
        text: qsTrId("sailfish_components_webview_textselection-la-selection_copied")

        verticalOffset: -Theme.itemSizeMedium - virtualKeyboardObserver.imSize
    }

    OfonoManager {
        id: ofonoManager
    }

    OfonoNetworkRegistration {
        id: cellular1Status

        property bool registered: status == "registered" || status == "roaming"

        modemPath: ofonoManager.modems[0] || ""
    }

    OfonoNetworkRegistration {
        id: cellular2Status

        property bool registered: status == "registered" || status == "roaming"

        modemPath: ofonoManager.modems[1] || ""
    }
}
