/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    property string error

    readonly property bool isPhone: Screen.sizeCategory <= Screen.Medium

    SilicaFlickable {
        anchors.fill: parent

        ViewPlaceholder {
            textFormat: Text.StyledText
            //% "Error: %1"
            text: qsTrId("components_pickers-la-print_error").arg(error)
            //% "Please, contact device administrator to fix the problem"
            hintText: qsTrId("components_pickers-la-contact_admin")
        }
    }

    Button {
        onClicked: pageStack.pop()

        anchors {
            horizontalCenter: parent.horizontalCenter
            bottom: parent.bottom
            bottomMargin: Theme.paddingLarge
        }
        preferredWidth: isPortrait && isPhone ? Theme.buttonWidthMedium : Theme.buttonWidthLarge
        //% "Close"
        text: qsTrId("component_pcikers-la-close")
    }
}