/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Gallery 1.0
import Sailfish.Pickers 1.0
import "private"

PickerDialog {
    id: imagePickerDialog

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: imagePickerDialog
    }

    ImageModel {
        id: imageModel
        selectedModel: _selectedModel
    }

    PickerGridView {
        id: gridView

        dialog: imagePickerDialog
        //: Images search field placeholder text
        //% "Search images"
        headerPlaceholderText: qsTrId("components_pickers-ph-search_images")
        emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")
        model: imageModel.model
        itemModel: imageModel
        contentType: ContentType.Image
        selectedCount: _selectedCount
        clearOnBackstep: _clearOnBackstep
        glassOnly: imagePickerDialog._background
        animationDuration: _animationDuration
    }
}
