/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Pickers 1.0
import Sailfish.Gallery 1.0
import "private"

PickerPage {
    id: documentPicker

    property alias _contentModel: documentModel

    //: Placeholder text of document search field in content picker
    //% "Search documents"
    property string _headerPlaceholderText: qsTrId("components_pickers-ph-search_documents")
    property string _emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")

    //% "Select document"
    title: qsTrId("components_pickers-he-select_document")

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: documentPicker
    }

    DocumentModel {
        id: documentModel
    }

    PickerGridView {
        id: gridView

        title: documentPicker.title
        headerPlaceholderText: _headerPlaceholderText
        emptyPlaceholderText: _emptyPlaceholderText
        itemModel: documentModel
        model: documentModel.model
        selectionEnabled: false
        isDialog: false
    }
}
