/*
 * Copyright (c) 2021 - 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_DEVICELOCKSETTINGS_H
#define SAILFISH_MDM_DEVICELOCkSETTINGS_H

#include <QString>
#include <QDBusVariant>
#include <QDBusInterface>
#include <QObject>
#include <QSharedPointer>

#include "mdm-devicelock.h"

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT DeviceLockSettings : public QObject
{
    Q_OBJECT

public:

    explicit DeviceLockSettings(QObject *parent = nullptr);

    static QList<Qt::DayOfWeek> fromStringScheduleDays(const QString &schedDays);
    static QPair<QTime, QTime> fromStringScheduleTime(const QString &schedTime);

    bool setPasswordStrength(bool strength);
    bool getPasswordStrength();

    DeviceLock::Result setPasswordLength(uint length);
    uint getPasswordLength();

    bool setPasswordMaxAge(uint days);
    uint getPasswordMaxAge();

    bool setPasswordWarningPeriod(uint days);
    uint getPasswordWarningPeriod();

    DeviceLock::Result setLoginTimeToLive(uint uid, QDate ttl);
    QDate getLoginTimeToLive(uint uid);

    DeviceLock::Result setScheduleDays(uint uid, const QList<Qt::DayOfWeek> &schedDays);
    QList<Qt::DayOfWeek> getScheduleDays(uint uid);

    DeviceLock::Result setScheduleTime(uint uid, const QPair<QTime, QTime> &schedTime);
    QPair<QTime, QTime> getScheduleTime(uint uid);

    DeviceLock::Result setLoginLocked(uint uid, bool value);
    bool getLoginLocked(uint uid);

private:
    QDBusInterface m_iface;
   
    QVariant getMethodOption(const QString &method, const QString &key);
    DeviceLock::Result setMethodOption(const QString &method, const QString &key,
                                       const QVariant &value);
    QVariant getUserMethodOption(uint uid, const QString &method,
                                 const QString &key);
    DeviceLock::Result setUserMethodOption(uint uid, const QString &method,
                                          const QString &key,
                                          const QVariant &value);

    Q_DISABLE_COPY(DeviceLockSettings)
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_DEVICELOCKSETTINGS_H

