/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (c) 2019 - 2022 Open Mobile Platform LLC.
**
** License: Proprietary
**
****************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.FileManager 1.0

FileItem {
    id: root

    property string baseName
    property string extension

    readonly property string iconSource: icon.source
    readonly property bool isParentDirectory: baseName == '..' && extension == ''

    property bool selected

    fileName: root.isParentDirectory
                    //% "Parent folder"
                  ? qsTrId("components_pickers-la-parent_folder")
                  : root.baseName + root.extension
    width: ListView.view.width
    highlighted: down || selected

    Binding {
        when: isParentDirectory
        target: icon
        property: "source"
        value: "image://theme/icon-m-page-up"
    }
}
