/*
 * Copyright (c) 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */
import QtQuick 2.5
import Sailfish.Silica 1.0

MenuItem {
    property bool needSelectDirectory
    property bool extractAllFiles
    property string archiveFile
    property ExtractorView extractorView

    onClicked: {
        if (archiveFile)
            extractorView.archiveFile = archiveFile

        if (needSelectDirectory) {
            if (extractAllFiles) {
                extractorView.selectedExtractPath(extractorView.extractAllFiles)
            } else {
                extractorView.selectedExtractPath(extractorView.extractFile, model.fileName, model.isDir)
            }
        } else {
            if (extractAllFiles) {
                extractorView.extractAllFiles()
            } else {
                extractorView.extractFile("", model.fileName, model.isDir)
            }
        }
    }

    //% "Extract to..."
    text: needSelectDirectory ? qsTrId("filemanager-me-extract_to")
                                //% "Extract here"
                              : qsTrId("filemanager-me-extract_here")
}
