/* This file is part of the Aurora SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Customer sign plugin"));
    component.setValue("Description", qsTranslate("installscript", "Plugin for customer package signing and CSR generation for Aurora IDE"));
}

function toNativePath(path)
{
    if (installer.value("os") === "win")
        return path.replace(/\//g, "\\");
    else
        return path;
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    var signKeysDir = toNativePath(installer.value("workspaceDir") + "/.auroraos-regular-keys/");
    var installDir = toNativePath(installer.value("TargetDir") + "/package-signing/");

    component.addOperation("Mkdir", signKeysDir);
    component.addOperation("Copy", installDir + "regular_key.pem", signKeysDir);
    component.addOperation("Copy", installDir + "regular_cert.pem", signKeysDir);
}