/****************************************************************************************
**
** SPDX-FileCopyrightText: 2014 Jolla Ltd.
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0

MouseArea {
    id: dialerButton

    property int key
    property string text
    property string secondaryText
    property bool down: pressed && containsMouse

    onClicked: dialer._buttonClicked(text)
    onPressed: {
        dialerButton.DragFilter.begin(mouse.x, mouse.y)
        dialer._buttonPressed(dialerButton, text)
    }
    onReleased: dialer._buttonReleased(text)
    onCanceled: {
        dialerButton.DragFilter.end()
        dialer._buttonCanceled(text)
    }
    onPressAndHold: {
        mouse.accepted = false
        dialer.pressAndHold(text, mouse)
    }

    onEntered: dialer._buttonEntered()
    onExited: dialer._buttonExited()

    width: dialer._buttonWidth
    height: dialer._buttonHeight
    cursorShape: enabled ? Qt.PointingHandCursor : Qt.ArrowCursor

    preventStealing: down && dialer.preventStealing
    onPreventStealingChanged: if (preventStealing) dialerButton.DragFilter.end()

    Label {
        id: numberLabel
        anchors {
            centerIn: parent
            verticalCenterOffset: dialer.vanityDialNumbersVisible ? -((vanityLabel.font.pixelSize)/2) : 0
        }
        font.pixelSize: Theme.fontSizeExtraLarge
        color: dialerButton.down ? dialer.pressedTextColor : dialer.textColor
        text: dialerButton.text
    }

    Label {
        id: vanityLabel
        anchors {
            horizontalCenter: parent.horizontalCenter
            top: numberLabel.bottom
            topMargin: -Theme.paddingSmall
        }
        font.pixelSize: Theme.fontSizeExtraSmall
        visible: dialer.vanityDialNumbersVisible
        color: dialerButton.down ? dialer.pressedSecondaryTextColor : dialer.secondaryTextColor
        text: dialerButton.secondaryText
    }
}
