/*
 * SPDX-FileCopyrightText: 2015 The Qt Company Ltd
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: LGPL21
 */

#ifndef QCONTACTBIRTHDAY_H
#define QCONTACTBIRTHDAY_H

#include <QtCore/qdatetime.h>

#include <QtContacts/qcontactdetail.h>

QT_BEGIN_NAMESPACE_CONTACTS

/* Leaf class */
class Q_CONTACTS_EXPORT QContactBirthday : public QContactDetail
{
public:
#ifndef Q_QDOC
    Q_DECLARE_CUSTOM_CONTACT_DETAIL(QContactBirthday)
#else
    static const DetailType Type;
#endif

    enum BirthdayField {
        FieldBirthday = 0,
        FieldCalendarId,
        FieldShowYear
    };

    void setDate(const QDate& _date);
    QDate date() const;
    void setDateTime(const QDateTime& _dateTime);
    QDateTime dateTime() const;
    void setCalendarId(const QString& _calendarId);
    QString calendarId() const;
    void setShowYear(bool _value);
    bool showYear() const;
};

QT_END_NAMESPACE_CONTACTS

#endif // QCONTACTBIRTHDAY_H
