/**
 * SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MDM_CALLHISTORY_P_H
#define MDM_CALLHISTORY_P_H

#include "mdm-callhistory.h"
#include "base-mdm-proxy-interface_p.h"
#include <QDBusInterface>
#include <QDBusArgument>

class QDBusPendingCallWatcher;

namespace Sailfish {
namespace Mdm {

class CallHistoryPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT
public:
    struct HistoryData {
        qint64 secondsSinceEpoch = 0;
        qint64 secondsAfterCall = 0;
        QString phoneNumber;
    };

    CallHistoryPrivate(Sailfish::Mdm::CallHistory *parent);
    ~CallHistoryPrivate();

    Sailfish::Mdm::CallHistory *q;

    virtual void customInitProxyPrep();

public Q_SLOTS:
    void handleSearchFinished(bool success, const QList<Sailfish::Mdm::CallHistoryPrivate::HistoryData> &dataList);
};

}
}

QDBusArgument &operator<<(QDBusArgument &, const Sailfish::Mdm::CallHistoryPrivate::HistoryData &);
const QDBusArgument &operator>>(const QDBusArgument &, Sailfish::Mdm::CallHistoryPrivate::HistoryData &);

Q_DECLARE_METATYPE(Sailfish::Mdm::CallHistoryPrivate::HistoryData)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::CallHistoryPrivate::HistoryData>)

#endif
