#!/bin/bash

check_response() {
    if [ $? -ne 0 ]; then
        echo "$1"
        exit 1
    fi
}

if [ $# -eq 0 ]; then
    echo "Can not change developer mode service state. No user was provided."
    exit 1
fi

username=$(getent passwd "$1" | cut -f 1 -d ":")
check_response "Can't get username"

# check if user is privileged
tmp=$(groups "$username" | grep -w sailfish-system)
if [ $? -ne 0 ]; then
    echo "User is not privileged. Skipping."
    exit 0
fi

sleep 5
gdbus call -y -d ru.omp.developermode -o / -m ru.omp.developermode.SetBlocked false
check_response "Failed to unblock developer mode service"

terminal_enabled=$(runuser -u "$username" -- env XDG_CONFIG_HOME="/home/$username/.config" dconf read /sailfish/administration/terminal 2>/dev/null)

if [ "$terminal_enabled" = "true" ] || [ "$terminal_enabled" = "false" ]; then
    if [ "$terminal_enabled" = "true" ]; then
        action="enable"
    else
        action="disable" 
    fi
    
    gdbus call -y -d ru.omp.developermode -o / -m ru.omp.developermode.SetTerminalEnabled "$terminal_enabled"
    check_response "Failed to $action terminal via D-Bus"

    runuser -u "$username" -- env XDG_CONFIG_HOME="/home/$username/.config" dconf reset /sailfish/administration/terminal 2>/dev/null
fi

exit 0
