/****************************************************************************************
**
** SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.6
import Sailfish.Media 1.0
import org.nemomobile.policy 1.0
import Amber.Mpris 1.0

MprisControls {
    id: controls

    property MprisController mprisController
    property int _playPauseClicks

    opacity: enabled ? 1.0 : 0.0
    isPlaying: mprisController.playbackStatus === Mpris.Playing
    artistAndSongText: { "artist": mprisController.metaData.contributingArtist || '',
                         "song": mprisController.metaData.title || '',
                         "albumArt": mprisController.metaData.artUrl || '' }

    nextEnabled: mprisController.canGoNext
    previousEnabled: mprisController.canGoPrevious
    playEnabled: mprisController.canPlay
    pauseEnabled: mprisController.canPause

    onPlayPauseRequested: {
        if (mprisController.playbackStatus === Mpris.Playing && mprisController.canPause) {
            mprisController.playPause()
        } else if (mprisController.playbackStatus !== Mpris.Playing && mprisController.canPlay) {
            mprisController.playPause()
        }
    }
    onNextRequested: if (mprisController.canGoNext) mprisController.next()
    onPreviousRequested: if (mprisController.canGoPrevious) mprisController.previous()

    Permissions {
        enabled: !!mprisController.currentService
        applicationClass: "player"

        Resource {
            id: keysResource
            type: Resource.HeadsetButtons
            optional: true
        }
    }

    Shortcut {
        enabled: keysResource.acquired && controls.playEnabled
        sequence: Qt.Key_MediaTogglePlayPause
        onActivated: controls.playPauseRequested()
    }
    Shortcut {
        enabled: keysResource.acquired && controls.playEnabled
        sequence: Qt.Key_MediaPlay
        onActivated: controls.mprisController.play()
    }
    Shortcut {
        enabled: keysResource.acquired && controls.pauseEnabled
        sequence: Qt.Key_MediaPause
        onActivated: controls.mprisController.pause()
    }
    Shortcut {
        enabled: keysResource.acquired && !!controls.mprisController
        sequence: Qt.Key_MediaStop
        onActivated: controls.mprisController.stop()
    }
    Shortcut {
        enabled: keysResource.acquired && controls.nextEnabled
        sequence: Qt.Key_MediaNext
        onActivated: controls.nextRequested()
    }
    Shortcut {
        enabled: keysResource.acquired && controls.previousEnabled
        sequence: Qt.Key_MediaPrevious
        onActivated: controls.previousRequested()
    }
    Shortcut {
        enabled: keysResource.acquired
        sequence: Qt.Key_ToggleCallHangup
        onActivated: {
            if (controls._playPauseClicks < 3) {
                playPauseTimer.restart()
                controls._playPauseClicks += 1
            }
        }
    }

    Timer {
        id: playPauseTimer

        interval: 250

        onTriggered: {
            if (controls._playPauseClicks === 1) {
                controls.playPauseRequested()
            } else if (controls._playPauseClicks === 2) {
                if (controls.nextEnabled) {
                    controls.nextRequested()
                }
            } else if (controls._playPauseClicks >= 3) {
                if (controls.previousEnabled) {
                    controls.previousRequested()
                }
            }
            controls._playPauseClicks = 0
        }
    }
}
