/**
 * SPDX-FileCopyrightText: Copyright 2022-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef HARDWARESWITCHVALUE_H
#define HARDWARESWITCHVALUE_H

#include <QObject>
#include <QString>
#include <QVariant>

namespace Sailfish {

class HardwareSwitchValuePrivate;

class Q_DECL_EXPORT HardwareSwitchValue : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QList<int> policyTypes READ policyTypes NOTIFY policyTypesChanged)
    Q_PROPERTY(QString key READ key WRITE setKey NOTIFY keyChanged)
    Q_PROPERTY(QVariant value READ value NOTIFY valueChanged)

public:
    explicit HardwareSwitchValue(QObject *parent = nullptr);

    static QList<int> keyPolicyTypes(const QString &key);
    QList<int> policyTypes() const;

    static QStringList keys();
    QString key() const;
    void setKey(const QString &newKey);

    static QVariant keyValue(const QString &key);
    QVariant value() const;

    // for MDM
    static bool setKeyValue(const QString &key, const QVariant &value);
    bool setValue(const QVariant &value);

signals:
    void policyTypesChanged();
    void keyChanged();
    void valueChanged();

private:
    HardwareSwitchValuePrivate *d_ptr;
    Q_DISABLE_COPY(HardwareSwitchValue)
    Q_DECLARE_PRIVATE(HardwareSwitchValue)
};
}

#endif // HARDWARESWITCHVALUE_H
