/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2021-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/
import QtQuick 2.6
import Sailfish.Silica 1.0

SilicaGridView {
    id: root

    property bool gridLayout
    property bool selectionEnabled
    property bool pasteMode
    property bool archiveMode
    property bool selectionMode
    property string description

    // Width of image background in FileItem
    readonly property real cellBackgroundSize: Theme.iconSizeLauncher // Theme.iconSizeMedium + Theme.paddingLarge * 2

    readonly property real contentCellWidthForLargeScreen: cellBackgroundSize + Theme.paddingLarge * 3 // Column width in FileItem
                                                           + Theme.paddingSmall * 3 // horizontal padding of Row in FileItem

    readonly property real chunkWidth: {
        var columns = Math.floor(width / contentCellWidthForLargeScreen)
        return (width - columns * contentCellWidthForLargeScreen) / columns
    }
    readonly property real cellWidthForLargeScreen: contentCellWidthForLargeScreen + chunkWidth

    readonly property real cellHeightForLargeScreen: cellBackgroundSize
                                                     + Theme.paddingSmall * 9
                                                     + nameMetrics.height * 2 + sizeMetrics.height
    readonly property real cellHeightForSmallScreen: cellBackgroundSize + Theme.paddingSmall * 3
    property real cellWidthForSmallScreen

    cellHeight: gridLayout ? cellHeightForLargeScreen : cellHeightForSmallScreen
    cellWidth: gridLayout ? cellWidthForLargeScreen : cellWidthForSmallScreen

    currentIndex: -1
    displaced: Transition { NumberAnimation { properties: "x,y"; easing.type: Easing.InOutQuad; duration: 200 } }
    cacheBuffer: cellHeight * 16
    width: parent.width

    onContentHeightChanged: if (!!__silica_contextmenu_instance) __silica_contextmenu_instance.VerticalAutoScroll.fixup()

    Behavior on contentY {
        enabled: !gridLayout
        NumberAnimation { duration: 20 }
    }

    FontMetrics {
        id: nameMetrics
        // This value should be taken from nameLabel in FileItem when the screen is large
        font.pixelSize: Theme.fontSizeExtraSmall
    }
    FontMetrics {
        id: sizeMetrics
        // This value should be taken from sizeLabel in FileItem when the screen is large
        font.pixelSize: Theme.fontSizeTiny
    }
}
