/*
 * Copyright (c) 2020 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_BASESTATION_H
#define SAILFISH_MDM_BASESTATION_H

#include <QObject>
#include <QString>
#include <QVariant>
#include <qofonoext/qofonoextcellwatcher.h>
#include <qofonoext/qofonoextcellinfo.h>

namespace Sailfish {
namespace Mdm {

class BaseStationPrivate;
class Q_DECL_EXPORT BaseStation: public QObject
{
    Q_OBJECT

public:

    explicit BaseStation(QObject *parent = 0);
    virtual ~BaseStation();

    struct BaseStationInfo {
        QString path;
        QString type;
        bool registered;

        // All types:
        int mcc;
        int mnc;
        int signalStrength;

        // GSM and WCDMA:
        int lac = 0;
        int cid = 0;

        // WCDMA:
        int psc = 0;

        // LTE:
        int ci = 0;
        int pci = 0;
        int tac = 0;
        int rsrp = 0;
        int rsrq = 0;
        int rssnr = 0;
        int cqi = 0;

        bool operator==(const BaseStationInfo &baseStationInfo) const;
    };
    QList<BaseStationInfo> getBaseStations();

Q_SIGNALS:
    void baseStationChanged(QList<BaseStationInfo> baseStations);

private slots:
    void onCellsChanged();

private:
    BaseStationPrivate *d_ptr;
    BaseStationInfo buildBaseStationInfo(QSharedPointer<QOfonoExtCell> aCell);

    Q_DISABLE_COPY(BaseStation)
    Q_DECLARE_PRIVATE(BaseStation)
};
} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_BASESTATION_H
