/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.0
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private

Item {
    id: root

    property real active
    property bool enableAnimation: true
    property var gridView
    property AppBarSearchField appBarSearchField
    property var contentModel
    property alias text: searchField.text
    property alias placeholderText: searchField.placeholderText
    property Page page: parent
    property real animatedY: active && visible ? Theme._itemSizeHeader : 0

    function _updateComponentsWidth() {} // Mock appbar internal stuff

    onActiveFocusChanged: if (activeFocus) searchField.forceActiveFocus()

    onActiveChanged: {
        if (gridView.contentY != 0 && enableAnimation) {
            if (active) {
                gridViewContentYAnimation.to = Math.min(gridView.contentY + height, gridView.contentHeight)
            } else {
                gridViewContentYAnimation.to = Math.max(gridView.contentY - height, 0)
            }
            gridViewContentYAnimation.restart()
        }
        if (gridView.contentY != 0 && !enableAnimation) {
            if (active) {
                gridView.contentY = Math.min(gridView.contentY + height, gridView.contentHeight)
            } else {
                gridView.contentY = Math.max(gridView.contentY - height, 0)
            }
        }
    }

    y: animatedY + SafeZoneRect.insets.top
    width: parent.width
    height: Theme._itemSizeHeader

    Behavior on animatedY {
        enabled: root.enableAnimation

        NumberAnimation {
            duration: 300
            easing.type: Easing.InOutQuad
        }
    }

    NumberAnimation {
        id: gridViewContentYAnimation

        duration: 300
        easing.type: Easing.InOutQuad
        target: gridView
        properties: "contentY"
    }

    Private.BackgroundRectangle {
        anchors.fill: parent

        visible: backgroundLoader.status !== Loader.Ready
        color: __silica_applicationwindow_instance._backgroundColor
    }

    Loader {
        id: backgroundLoader

        anchors.fill: parent

        sourceComponent: page && page.background
    }    

    AppBarSearchField {
        id: searchField

        onTextChanged: {
            if (visible && contentModel) {
                contentModel.filter = text.toLowerCase().trim()
                appBarSearchField.text = text
            }
        }

        onVisibleChanged: {
            if (!visible && activeFocus) {
                appBarSearchField.forceActiveFocus()
            }
        }

        EnterKey.onClicked: focus = false

        anchors.centerIn: parent
        width: parent.width - 2 * Theme.paddingLarge
        backgroundEnabled: true
        EnterKey.iconSource: "image://theme/icon-m-keyboard-enter-close"
    }

    Rectangle {
        y: parent.height - height
        width: parent.width
        height: Theme._lineWidth
        opacity: Theme.opacityFaint
        color: Theme.primaryColor
    }
}
