/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Aurora.Controls 1.0

PickerPage {
    id: root

    property var _contentModel
    property string _searchPlaceholderText
    property alias _emptyPlaceholderText: gridView.emptyPlaceholderText

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: root
    }

    AppBar {
        id: appBar

        headerText: title
        divider: searchItem.y === SafeZoneRect.insets.top

        AppBarSpacer {}

        AppBarButton {
            onClicked: gridView.gridLayout = !gridView.gridLayout

            icon.source: "image://theme/icon-splus-%1".arg(gridView.gridLayout ? "list" : "cage")

            context: gridView.gridLayout
                       //% "Show list"
                     ? qsTrId("components_pickers-la-show_grid")
                       //% "Show grid"
                     : qsTrId("components_pickers-la-show_list")
        }

        AppBarButton {
            onClicked: {
                if (searchItem.active) {
                    searchItem.text = ""
                    searchItem.focus = false
                    searchItem.active = false
                } else {
                    searchItem.active = true
                    searchItem.forceActiveFocus()
                }
            }
            visible: Screen.sizeCategory > Screen.Medium || (SafeZoneRect._orientation & Orientation.PortraitMask)

            icon.source: "image://theme/icon-splus-search"
            //% "Search"
            context: qsTrId("components_pickers-la-search")
            highlighted: searchItem.active
        }

        AppBarSearchField {
            id: appBarSearchField

            onTextChanged: {
                if (visible && _contentModel) {
                    _contentModel.filter = text.toLowerCase().trim()
                    searchItem.text = text
                }
            }

            onVisibleChanged: {
                searchItem.enableAnimation = false
                if (visible) {
                    searchItem.visible = false
                } else {
                    if (activeFocus) {
                        searchItem.forceActiveFocus()
                        searchItem.active = true
                    }
                    if (text != "") {
                        searchItem.active = true
                    }

                    searchItem.visible = true
                }

                searchItem.enableAnimation = true
            }

            EnterKey.onClicked: focus = false
            EnterKey.iconSource: "image://theme/icon-m-keyboard-enter-close"

            visible: Screen.sizeCategory <= Screen.Medium && (SafeZoneRect._orientation & Orientation.LandscapeMask)

            preferredWidth: visible ? appBar.width * 0.5 - 2 * Theme.paddingMedium : 0
            backgroundEnabled: true
            placeholderText: root._searchPlaceholderText
        }
    }

    PickerGridView {
        id: gridView

        anchors.topMargin: appBar.height + Theme.paddingMedium + searchItem.y

        itemModel: root._contentModel
        model: root._contentModel.model
    }

    SearchSlidingItem {
        id: searchItem

        appBarSearchField: appBarSearchField
        contentModel: _contentModel
        gridView: gridView
        placeholderText: root._searchPlaceholderText
    }
}
