/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

pragma Singleton

import QtQuick 2.6

QtObject {
    id: root

    function setTimeout(callback, interval, args, destroyOnTriggered) {
        if (!interval) {
            interval = 1
        }

        const timer = Qt.createQmlObject(
                        "import QtQuick 2.0; Timer { interval: %1 }".arg(interval), root)

        if (!timer) {
            return null
        }

        timer.triggered.connect(function() {
            if (callback) {
                callback(args)
            }

            if (destroyOnTriggered || destroyOnTriggered === undefined) {
                timer.destroy()
            }
        })

        timer.start()

        return timer
    }
}
