/****************************************************************************
**
** SPDX-FileCopyrightText: 2022-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.FileManager 1.0 as FileManager

FileGridView {
    id: gridView

    readonly property bool searchActive: itemModel && itemModel.filter !== ""
    //% "Empty folder"
    property string emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")
    property var itemModel
    property string searchText
    property int selectedCount: 0
    property bool isDialog

    anchors.fill: parent
    cellWidthForSmallScreen: parent.width
    currentIndex: -1

    delegate: FileManager.FileGridItem {
        onClicked: {
            if (isDialog) {
                itemModel.updateSelected(index, !model.selected)

                if (itemModel.singleSelectionMode) {
                    gridView.parent._updateSelection()
                }
            } else {
                _customSelectionHandler(itemModel, index, true)
            }
        }

        onPressAndHold: popupMenu.open()

        size: model.fileSize
        modified: model.lastModified
        searchText: gridView.searchText
        isDir: false
        fileName: model.filePath
        down: model.selected || (isDialog &&  _selectedModel && _selectedModel.selected(model.filePath)) || pressed

        PreviewPopupMenu {
            id: popupMenu

            fileName: model.url
        }
    }

    ViewPlaceholder {
        //% "Nothing found"
        text: searchActive ? qsTrId("components_pickers-ph-nothing-found") : emptyPlaceholderText
        enabled: itemModel.count === 0
                 && (itemModel.status === DocumentGalleryModel.Finished
                     || itemModel.status === DocumentGalleryModel.Idle)
    }

    VerticalScrollDecorator {}
}
