/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

pragma Singleton

import QtQuick 2.6

QtObject {
    id: root

    /*!
      \a callback - callback function.
      \a interval - timeout in ms. default: 1ms.
      \a args - object of dependencies, will be sended as callback args.
      \a destroyOnTriggered - destroy timer on timeout. default: true
      */
    function setTimeout(callback, interval, args, destroyOnTriggered) {
        if (!interval) {
            interval = 1
        }

        const timer = Qt.createQmlObject(
                        "import QtQuick 2.0; Timer { interval: %1 }".arg(interval), root)

        if (!timer) {
            return null
        }

        timer.triggered.connect(function() {
            if (callback) {
                callback(args)
            }

            if (destroyOnTriggered || destroyOnTriggered === undefined) {
                timer.destroy()
            }
        })

        timer.start()

        return timer
    }
}
