/*
 * Copyright (c) 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SSU_H
#define SAILFISH_MDM_SSU_H

#include <QObject>
#include <QVariant>

namespace Sailfish {
namespace Mdm {

class SsuPrivate;
class Q_DECL_EXPORT Ssu : public QObject
{
    Q_OBJECT

public:
    Q_PROPERTY(QString domain READ domain)
    Q_PROPERTY(QVariantMap domainConfig READ domainConfig WRITE setDomainConfig)
    Q_PROPERTY(bool isRegistered READ isRegistered)
    Q_PROPERTY(bool error READ error)
    Q_PROPERTY(QString lastError READ lastError)

    explicit Ssu(QObject *parent = nullptr);

    QString domain() const;
    QVariantMap domainConfig() const;
    void setDomainConfig(const QVariantMap &config);
    bool isRegistered() const;
    bool error() const;
    QString lastError() const;

    Q_INVOKABLE void registerDevice(const QString &user, const QString &password);
    Q_INVOKABLE void revokeRegistration();
    Q_INVOKABLE QString getConfigValue(const QString &key) const;
    Q_INVOKABLE void setConfigValue(const QString &key, const QString &value);
    Q_INVOKABLE bool setExtraHeaders(const QString &json);

signals:
    void done();

private:
    SsuPrivate *d_ptr;
    Q_DISABLE_COPY(Ssu)
    Q_DECLARE_PRIVATE(Ssu)
};

}
}

#endif // SAILFISH_MDM_SSU_H
