/*
 * Copyright (c) 2022 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMWHITELIST_H
#define SAILFISH_MDM_SIMWHITELIST_H

#include <QDBusArgument>
#include <QDBusInterface>
#include <QObject>
#include <QString>

namespace Sailfish {
namespace Mdm {

class SimWhitelistPrivate;

class Q_DECL_EXPORT SimWhitelist : public QObject
{
    Q_OBJECT

public:
    Q_PROPERTY(bool enabled READ isEnabled WRITE setEnabled NOTIFY enabledChanged)
    Q_PROPERTY(bool blocked READ isBlocked NOTIFY blockedChanged)
    Q_PROPERTY(QStringList blockedSims READ blockedSims NOTIFY blockedSimsChanged)

    explicit SimWhitelist(QObject *parent = 0);
    ~SimWhitelist();

    Q_DECL_DEPRECATED bool isBlocked() const;
    bool isEnabled() const;
    void setEnabled(bool enabled);

    void add(const QString &iccid);
    void remove(const QString &iccid);

    QStringList iccids() const;

    QStringList blockedSims() const;

signals:
    void enabledChanged(bool enabled);
    Q_DECL_DEPRECATED void blockedChanged(bool blocked);
    void blockedSimsChanged(const QStringList &paths);

private:
    SimWhitelistPrivate *d_ptr;
    Q_DISABLE_COPY(SimWhitelist)
    Q_DECLARE_PRIVATE(SimWhitelist)
};
} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_SIMWHITELIST_H
